﻿//////////////////////////////////////////////
// ListBox.h
//
//////////////////////////////////////////////

/// Defines / macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkWinUi
{
	class System ;
}

/// Includes ---------------------------------

// nkWinUi
#include "Component.h"

#include "../Dll/DllDefines.h"

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

// Standards
#include <functional>
#include <map>
#include <unordered_map>

/// Class ------------------------------------

namespace nkWinUi
{
	class DLL_WINUI_EXPORT ListBox : public Component
	{
		public :

			// Les items rangés dedans
			class DLL_WINUI_EXPORT Item final
			{
				public :

					// Constructor, destructor
					Item () noexcept ;
					~Item () ;

					// Getters
					ListBox* getParentList () const ;
					nkMemory::StringView getLabel () const ;
					void* getAttachedData () const ;

					// Setters
					void setParentList (ListBox* parent) ;
					void setLabel (nkMemory::StringView label) ;
					void setAttachedData (void* data) ;

				private :

					// Attributs
					ListBox* _parentList ;
					nkMemory::String _label ;

					void* _attachedData ;
			} ;

		public :
		
			// Constructeur, destructeur
			ListBox (System* system) noexcept ;
			ListBox (const ListBox&) = delete ;
			virtual ~ListBox () ;

			// Getters
			Item* getItemFromLabel (nkMemory::StringView label) const ;
			Item* getItemFromData (void* data) const ;
			Item* getItemFromIndex (unsigned int index) const ;
			virtual Item* getCurrentSelection () const ;
			virtual int getCurrentSelectionIndex () const ;
			std::function<void (ListBox*)> getSelectionCallback () const ;
			unsigned int getItemCount () const ;

			// Setters
			void setSelectionCallback (std::function<void (ListBox*)> value) ;

			// Manipulation d'Items
			virtual Item* insertItem (nkMemory::StringView text, void* data) ;
			virtual void* deleteItem (nkMemory::StringView name) ;
			virtual void changeItemLabel (nkMemory::StringView oldText, nkMemory::StringView newText) ;
			void changeItemData (nkMemory::StringView text, void* newData) ;
			virtual bool setSelected (nkMemory::StringView text) ;
			virtual bool setSelectedIndex (unsigned int index) ;
			bool setSelectedData (void* data) ;
			virtual void clearItems () ;

			// Import / Export
			virtual void exportIntrospection (nkExport::Node* rootNode) override ;
			virtual void importClassFromTree (nkExport::Node* rootNode) override ;

			// Operators
			ListBox& operator= (const ListBox&) = delete ;

		public :

			// Statics
			static nkMemory::UniquePtr<ListBox> create (System* system = nullptr) ;

		protected :
		
			// Attributs
			std::map<std::string, nkMemory::UniquePtr<Item>> _memory ;
			std::unordered_map<void*, Item*> _memoryPerData ;

			// Sélection active
			Item* _selected ;
				
			// Callback
			std::function<void (ListBox*)> _selectionCallback ;

			// Height de ligne
			unsigned int _lineHeight ;
	} ;
}